clear all
set matsize 10000
set maxvar 10000
set more off

cd "\IRI data"
	
*** Program to estimate margbutr prices

	import delimited "margbutr_select.csv"
	drop rank category revenue 
	
	merge m:1 iri_key using stores_market.dta
	drop _merge
	
	merge m:1 iri_key using entries_wide_11.dta
	drop _merge
	
** Setup
	rename iri_key stores
	rename week weekid
	replace weekid = weekid - 1113
	egen upc = group(colupc)
	egen id = group(stores upc)
	xtset id weekid
	
	tsfill
	by id, sort: egen max = max(upc)
		drop upc
		rename max upc
	by id, sort: egen max = max(stores)
		drop stores
		rename max stores
	
	egen mkt = group(market)
	by id, sort: egen max = max(mkt)
		drop mkt
		rename max mkt
	
** Create WM post-entry and entry week indicator

	rename wmid* idwm*
	forvalues i=1/19 {
		capture gen wm`i' = (weekid >= week`i')
		capture gen enter`i' = (weekid == week`i')
		capture replace dis`i' = 0 if wm`i' == 0
		}
	egen wm = rowtotal(wm*)
	egen enter = rowtotal(enter*)
	
*	encode market, gen(mkt)	
	
/*	egen dis = rowtotal(dis*)
	forvalues i=1/19 {
		capture gen dis`i'_2 = dis`i'^2
		capture gen dis`i'_3 = dis`i'^3
		}
	egen dis_sq = rowtotal(dis*_2)
	egen dis_cu = rowtotal(dis*_3)
	drop dis*_2 dis*_3
*/	
	* Distance spline
	forvalues s=1/1 {
		forvalues i=1/24 {
			capture gen I_`i'_`s' = (dis`i' <= `s' & dis`i' > 0 )
			}
		egen wm_`s' = rowtotal(I_*_`s')
		drop I*
		}

	forvalues s=3(2)11 {
		local s0 = `s'-2
		forvalues i=1/24 {
			capture gen I_`i'_`s' = (dis`i' <= `s' & dis`i' > `s0' )
			}
		egen wm_`s' = rowtotal(I_*_`s')
		drop I*
		}
	
** Merge in store names
	rename stores iri_key
	merge m:1 iri_key using store_names.dta
	drop if _merge == 2
	drop _merge
	rename iri_key stores
	
	* Merge in chain info
	merge m:1 name using chain.dta
	drop _merge
	
	gen missing_chain = (chainid ==.)
	
	replace firmtype = 3 if firmtype == 4
	encode name, gen(chain)
	replace chain = 0 if missing_chain == 1
	
** Treatment groups
	by stores, sort: egen treat_nwm = max(wm)
	by stores, sort: egen wm0 = min(wm)
	
	gen wm_diff = treat_nwm - wm0
	
** Create variables

	merge m:1 monthid using cpi.dta
	drop _merge
	
	gen ppvol = (dollars / (units * vol_eq))  / cpi * 100
	gen logp = log(ppvol)
	
	compress
	
keep stores weekid enter wm wm_* chain f d pr upc id logp firmtype treat_nwm mkt dollars units vol_eq cpi
		
	gen wm_lt7 = wm_1+wm_3+wm_5+wm_7
	gen wm_lt5 = wm_1+wm_3+wm_5
	
	save margbutr_select.dta, replace
		
** Regressions
	cd "\Results"
	
	reg logp enter wm_1-wm_11 i.weekid, cluster(stores)
		outreg2 using final_margbutr, excel
	reg logp enter wm_1-wm_11 i.upc i.weekid, cluster(stores)
		outreg2 using final_margbutr, excel
	reg logp enter wm_1-wm_11 i.mkt i.upc i.weekid, cluster(stores)
		outreg2 using final_margbutr, excel
	reg logp enter wm_1-wm_11 i.chain i.mkt i.upc i.weekid, cluster(stores)
		outreg2 using final_margbutr, excel
	reg logp enter wm_1-wm_11 i.treat_nwm i.chain i.mkt i.upc i.weekid, cluster(stores)
		outreg2 using final_margbutr, excel
	xtreg logp enter wm_1-wm_11 i.upc i.weekid, fe i(stores) cluster(stores)	
		outreg2 using final_margbutr, excel
	xtreg logp enter wm_1-wm_11 i.weekid, fe i(id) cluster(stores)	
		outreg2 using final_margbutr, excel
	xtreg logp enter wm_1-wm_11 i.weekid c.weekid#i.upc c.weekid#c.weekid#i.upc, fe i(id) cluster(stores)	
		outreg2 using final_margbutr, excel
	xtreg logp enter wm_1-wm_11 i.weekid c.weekid#i.upc c.weekid#c.weekid#i.upc c.weekid#i.mkt c.weekid#c.weekid#i.mkt, fe i(id) cluster(stores)	
		outreg2 using final_margbutr, excel
	xtreg logp enter wm_1-wm_11 i.weekid c.weekid#i.upc c.weekid#c.weekid#i.upc c.weekid#i.mkt c.weekid#c.weekid#i.mkt c.weekid#i.treat_nwm c.weekid#c.weekid#i.treat_nwm, fe i(id) cluster(stores)	
		outreg2 using final_margbutr, excel


	reghdfe logp enter wm_lt5 c.weekid#i.upc c.weekid#c.weekid#i.upc c.weekid#i.mkt c.weekid#c.weekid#i.mkt c.weekid#i.treat_nwm c.weekid#c.weekid#i.treat_nwm, a(weekid id) cluster(stores) keepsing
		outreg2 using final_margbutr, excel		

	reghdfe pr enter wm_1-wm_11 c.(c.weekid##c.weekid)#i.(mkt upc treat_nwm) if logp~=., a(weekid id) cluster(stores) keepsing
		outreg2 using final_margbutr_sales, excel replace
	reghdfe pr enter wm_lt5 c.(c.weekid##c.weekid)#i.(mkt upc treat_nwm) if logp~=., a(weekid id) cluster(stores) keepsing
		outreg2 using final_margbutr_sales, excel	
	
	